
(* 2x1 flyways 1 xbot (actual physical, left flyway set as master, right flyway set as sector 1) - PMC_Sector_Activate, PMC_Sector_Deactivate, PMC_Sector_Recover, PMC_Sector_GetStatus *)
FUNCTION_BLOCK Example35_Sectors
	IF NOT(Execute) THEN
		UserReconnectFinished := FALSE;
	END_IF; 

	//move xbot 1 to the non sector flyway
	PMC_XYMotion1(Execute := Execute,cmdLB := 0,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.12,PosY := 0.12,EndVel := 0,MaxVel := 1.0,MaxAcc := 10.0,PM_Controller := PM_Controller);

	//deactivate sector 1
	PMC_Sector_Deactivate1(Execute := PMC_XYMotion1.Done,SectorID := 1,PM_Controller := PM_Controller);
	//tell user that they can disconnect the sector flyway
	UserCanDisconnectFlyway := PMC_Sector_Deactivate1.Done;

	//get the status of sector 1
	PMC_Sector_GetStatus1(Execute := PMC_Sector_Deactivate1.Done,SectorID := 1,PM_Controller := PM_Controller);

	//try to move xbot 1 to the sector flyway
	PMC_XYMotion2(Execute := PMC_Sector_GetStatus1.Done,cmdLB := 0,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.36,PosY := 0.12,EndVel := 0,MaxVel := 1.0,MaxAcc := 10.0,PM_Controller := PM_Controller);

	//activate sector once user says that they are done reconnecting the flyway
	PMC_Sector_Activate1(Execute := UserReconnectFinished AND PMC_XYMotion2.Ack,SectorID := 1,PM_Controller := PM_Controller);

	//recover sector once the sector is done activating
	PMC_Sector_Recover1(Execute := PMC_Sector_Activate1.Done,SectorID := 1,PM_Controller := PM_Controller);

	//Done once the xbot reaches the sector flyway
	Done := PMC_XYMotion2.Done;
END_FUNCTION_BLOCK
